
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")


# Set objective function
m.setObjective(2*protein_bars + 8*cornichons + 5*chicken_thighs + 7*chicken_breasts, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*protein_bars + 11*chicken_thighs >= 30)
m.addConstr(4*protein_bars + 3*cornichons >= 18)
m.addConstr(4*protein_bars + 11*chicken_thighs + 10*chicken_breasts >= 35)
m.addConstr(3*cornichons + 11*chicken_thighs + 10*chicken_breasts >= 35)
m.addConstr(4*protein_bars + 3*cornichons + 11*chicken_thighs >= 35)
m.addConstr(4*protein_bars + 11*chicken_thighs + 10*chicken_breasts >= 36)
m.addConstr(3*cornichons + 11*chicken_thighs + 10*chicken_breasts >= 36)
m.addConstr(4*protein_bars + 3*cornichons + 11*chicken_thighs >= 36)
m.addConstr(4*protein_bars + 11*chicken_thighs + 10*chicken_breasts >= 31)
m.addConstr(3*cornichons + 11*chicken_thighs + 10*chicken_breasts >= 31)
m.addConstr(4*protein_bars + 3*cornichons + 11*chicken_thighs >= 31)
m.addConstr(4*protein_bars + 3*cornichons + 11*chicken_thighs + 10*chicken_breasts >= 31)
m.addConstr(5*chicken_thighs + 11*chicken_breasts >= 104)
m.addConstr(10*protein_bars + 12*cornichons >= 53)
m.addConstr(12*cornichons + 11*chicken_breasts >= 80)
m.addConstr(10*protein_bars + 12*cornichons + 5*chicken_thighs >= 64)
m.addConstr(12*cornichons + 5*chicken_thighs + 11*chicken_breasts >= 64)
m.addConstr(10*protein_bars + 12*cornichons + 11*chicken_breasts >= 64)
m.addConstr(10*protein_bars + 12*cornichons + 5*chicken_thighs >= 58)
m.addConstr(12*cornichons + 5*chicken_thighs + 11*chicken_breasts >= 58)
m.addConstr(10*protein_bars + 12*cornichons + 11*chicken_breasts >= 58)
m.addConstr(10*protein_bars + 12*cornichons + 5*chicken_thighs >= 97)
m.addConstr(12*cornichons + 5*chicken_thighs + 11*chicken_breasts >= 97)
m.addConstr(10*protein_bars + 12*cornichons + 11*chicken_breasts >= 97)
m.addConstr(10*protein_bars + 12*cornichons + 5*chicken_thighs + 11*chicken_breasts >= 97)
m.addConstr(5*protein_bars - 5*chicken_thighs >= 0)
m.addConstr(1*protein_bars - 3*cornichons >= 0)
m.addConstr(4*protein_bars + 3*cornichons <= 83)
m.addConstr(4*protein_bars + 10*chicken_breasts <= 141)
m.addConstr(3*cornichons + 11*chicken_thighs <= 54)
m.addConstr(11*chicken_thighs + 10*chicken_breasts <= 148)
m.addConstr(4*protein_bars + 11*chicken_thighs <= 96)
m.addConstr(10*protein_bars + 12*cornichons + 11*chicken_breasts <= 284)
m.addConstr(10*protein_bars + 12*cornichons + 5*chicken_thighs <= 264)

m.addConstr(4*protein_bars + 3*cornichons + 11*chicken_thighs + 10*chicken_breasts <= 154)
m.addConstr(10*protein_bars + 12*cornichons + 5*chicken_thighs + 11*chicken_breasts <= 437)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

