
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="protein_bars", lb=-gurobi.GRB.INFINITY)
    x1 = model.addVar(name="cornichons", lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name="chicken_thighs", lb=-gurobi.GRB.INFINITY)
    x3 = model.addVar(name="chicken_breasts", lb=-gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(2*x0 + 8*x1 + 5*x2 + 7*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4*x0 + 3*x1 >= 18)
    model.addConstr(4*x0 + 11*x2 + 10*x3 >= 35)
    model.addConstr(3*x1 + 11*x2 + 10*x3 >= 35)
    model.addConstr(4*x0 + 3*x1 + 11*x2 >= 35)
    model.addConstr(4*x0 + 11*x2 + 10*x3 >= 36)
    model.addConstr(3*x1 + 11*x2 + 10*x3 >= 36)
    model.addConstr(4*x0 + 3*x1 + 11*x2 >= 36)
    model.addConstr(4*x0 + 11*x2 + 10*x3 >= 31)
    model.addConstr(3*x1 + 11*x2 + 10*x3 >= 31)
    model.addConstr(4*x0 + 3*x1 + 11*x2 >= 31)
    model.addConstr(4*x0 + 3*x1 + 11*x2 + 10*x3 >= 31)
    model.addConstr(5*x2 + 11*x3 >= 104)
    model.addConstr(10*x0 + 12*x1 >= 53)
    model.addConstr(12*x1 + 11*x3 >= 80)
    model.addConstr(10*x0 + 12*x1 + 5*x2 >= 64)
    model.addConstr(12*x1 + 5*x2 + 11*x3 >= 64)
    model.addConstr(10*x0 + 12*x1 + 11*x3 >= 64)
    model.addConstr(10*x0 + 12*x1 + 5*x2 >= 58)
    model.addConstr(12*x1 + 5*x2 + 11*x3 >= 58)
    model.addConstr(10*x0 + 12*x1 + 11*x3 >= 58)
    model.addConstr(10*x0 + 12*x1 + 5*x2 >= 97)
    model.addConstr(12*x1 + 5*x2 + 11*x3 >= 97)
    model.addConstr(10*x0 + 12*x1 + 11*x3 >= 97)
    model.addConstr(10*x0 + 12*x1 + 5*x2 + 11*x3 >= 97)
    model.addConstr(5*x0 - 5*x2 >= 0)
    model.addConstr(x0 - 3*x1 >= 0)
    model.addConstr(4*x0 + 3*x1 <= 83)
    model.addConstr(4*x0 + 10*x3 <= 141)
    model.addConstr(3*x1 + 11*x2 <= 54)
    model.addConstr(11*x2 + 10*x3 <= 148)
    model.addConstr(4*x0 + 11*x2 <= 96)
    model.addConstr(10*x0 + 12*x1 + 11*x3 <= 284)
    model.addConstr(10*x0 + 12*x1 + 5*x2 <= 264)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objval}")
        print(f"Protein bars: {x0.x}")
        print(f"Cornichons: {x1.x}")
        print(f"Chicken thighs: {x2.x}")
        print(f"Chicken breasts: {x3.x}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
