
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
vitamin_b1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
zinc = m.addVar(vtype=gp.GRB.INTEGER, name="zinc")
vitamin_b7 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b7")
vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")

# Set objective function
m.setObjective(8*calcium + 7*vitamin_b1 + 2*zinc + 9*vitamin_b7 + 3*vitamin_d, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*calcium + 17*vitamin_b1 + 4*zinc + 3*vitamin_b7 + 1*vitamin_d <= 114, "r0")
m.addConstr(9*calcium + 13*vitamin_b1 + 3*zinc + 9*vitamin_b7 + 17*vitamin_d <= 135, "r1")
m.addConstr(15*calcium + 5*vitamin_b1 + 15*zinc + 13*vitamin_b7 + 6*vitamin_d <= 158, "r2")
m.addConstr(3*calcium + 4*vitamin_b1 + 8*zinc + 11*vitamin_b7 + 3*vitamin_d <= 146, "r3")
m.addConstr(1*calcium + 15*vitamin_b1 + 14*zinc + 8*vitamin_b7 + 1*vitamin_d <= 178, "r4")

# ... (rest of the constraints from the JSON "constraints" section)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('calcium:', calcium.x)
    print('vitamin_b1:', vitamin_b1.x)
    print('zinc:', zinc.x)
    print('vitamin_b7:', vitamin_b7.x)
    print('vitamin_d:', vitamin_d.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

