
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="calcium", vtype=gp.GRB.INTEGER)  # milligrams of calcium
x1 = m.addVar(name="vitamin_B1")  # milligrams of vitamin B1
x2 = m.addVar(name="zinc", vtype=gp.GRB.INTEGER)  # milligrams of zinc
x3 = m.addVar(name="vitamin_B7", vtype=gp.GRB.INTEGER)  # milligrams of vitamin B7
x4 = m.addVar(name="vitamin_D", vtype=gp.GRB.INTEGER)  # milligrams of vitamin D

# Define the objective function
m.setObjective(8 * x0 + 7 * x1 + 2 * x2 + 9 * x3 + 3 * x4, gp.GRB.MAXIMIZE)

# Add constraints
# Muscle growth index constraints
m.addConstr(12 * x0 + 17 * x1 >= 16)
m.addConstr(12 * x0 + 3 * x3 >= 10)
m.addConstr(4 * x2 + 3 * x3 >= 12)

# Kidney support index constraints
m.addConstr(9 * x2 + 17 * x4 >= 10)
m.addConstr(13 * x1 + 17 * x4 >= 20)
m.addConstr(13 * x1 + 3 * x2 >= 11)
m.addConstr(9 * x0 + 3 * x2 <= 64)
m.addConstr(9 * x0 + 3 * x2 >= 21)

# Cardiovascular support index constraints
m.addConstr(15 * x0 + 5 * x1 + 6 * x4 >= 19)
m.addConstr(15 * x0 + 13 * x3 + 6 * x4 >= 26)

# Cognitive performance index constraints
m.addConstr(11 * x3 + 3 * x4 >= 24)
m.addConstr(8 * x2 + 3 * x4 <= 95)

# Digestive support index constraints
m.addConstr(x0 + x2 + x3 >= 22)
m.addConstr(x0 + x1 + x3 >= 22)
m.addConstr(x1 + x3 + x4 >= 22)
m.addConstr(x0 + x3 + x4 >= 22)
m.addConstr(x0 + x2 + x3 >= 24)

# Bounds
m.addConstr(x0 <= 114)
m.addConstr(17 * x1 <= 135)
m.addConstr(15 * x2 <= 158)
m.addConstr(13 * x3 <= 146)
m.addConstr(6 * x4 <= 178)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0 (calcium): ", x0.varValue)
    print("x1 (vitamin B1): ", x1.varValue)
    print("x2 (zinc): ", x2.varValue)
    print("x3 (vitamin B7): ", x3.varValue)
    print("x4 (vitamin D): ", x4.varValue)
else:
    print("The model is infeasible or unbounded.")
