
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
knishes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knishes")


# Set objective function
m.setObjective(3 * chicken_thighs + 2 * apple_pies + 6 * knishes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * chicken_thighs + 19 * apple_pies >= 57, "calcium_constraint1")
m.addConstr(6 * chicken_thighs + 17 * knishes >= 59, "calcium_constraint2")
m.addConstr(6 * chicken_thighs + 19 * apple_pies + 17 * knishes >= 59, "calcium_constraint3")
m.addConstr(-10 * chicken_thighs + apple_pies >= 0, "constraint4")
m.addConstr(6 * chicken_thighs + 19 * apple_pies + 17 * knishes <= 252, "calcium_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chicken_thighs:', chicken_thighs.x)
    print('apple_pies:', apple_pies.x)
    print('knishes:', knishes.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

