
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables - all are continuous
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_thighs")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="apple_pies")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="knishes")

# Set objective function
m.setObjective(3*x1 + 2*x2 + 6*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 19*x2 >= 57, "calcium_from_chicken_and_pies")
m.addConstr(6*x1 + 17*x3 >= 59, "calcium_from_chicken_and_knishes")
m.addConstr(6*x1 + 19*x2 + 17*x3 >= 59, "total_calcium")
m.addConstr(-10*x1 + x2 >= 0, "chicken_pies_balance")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
