
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="chicken_thighs", lb=-float('inf'))  # No lower bound
    x2 = model.addVar(name="apple_pies", lb=-float('inf'))  # No lower bound
    x3 = model.addVar(name="knishes", lb=-float('inf'))  # No lower bound

    # Define the objective function
    model.setObjective(3*x1 + 2*x2 + 6*x3, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(6*x1 + 19*x2 >= 57)
    model.addConstr(6*x1 + 17*x3 >= 59)
    model.addConstr(6*x1 + 19*x2 + 17*x3 >= 59)
    model.addConstr(-10*x1 + x2 >= 0)

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Chicken thighs: {x1.x}")
        print(f"Apple pies: {x2.x}")
        print(f"Knishes: {x3.x}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
