
import gurobipy as gp

# Create a new model
model = gp.Model("office_supplies")

# Create variables
blue_highlighters = model.addVar(vtype=gp.GRB.INTEGER, name="blue_highlighters")
staplers = model.addVar(vtype=gp.GRB.INTEGER, name="staplers")
cafeteria_chairs = model.addVar(vtype=gp.GRB.INTEGER, name="cafeteria_chairs")


# Set objective function
model.setObjective(5 * blue_highlighters + 8 * staplers + 3 * cafeteria_chairs, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3.05 * blue_highlighters + 0.11 * staplers + 7.99 * cafeteria_chairs <= 67, "storage_space")
model.addConstr(0.11 * staplers + 7.99 * cafeteria_chairs <= 61, "staplers_chairs_space")
model.addConstr(3.05 * blue_highlighters + 7.99 * cafeteria_chairs <= 22, "highlighters_chairs_space")
model.addConstr(3.05 * blue_highlighters + 0.11 * staplers + 7.99 * cafeteria_chairs <= 57, "total_space_alt")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Blue Highlighters: {blue_highlighters.x}")
    print(f"Staplers: {staplers.x}")
    print(f"Cafeteria Chairs: {cafeteria_chairs.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

