
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="blue_highlighters")
x2 = m.addVar(vtype=GRB.INTEGER, name="staplers")
x3 = m.addVar(vtype=GRB.INTEGER, name="cafeteria_chairs")

# Set objective function
m.setObjective(5*x1 + 8*x2 + 3*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.11*x2 + 7.99*x3 <= 61, "staplers_and_chairs")
m.addConstr(3.05*x1 + 7.99*x3 <= 22, "highlighters_and_chairs")
m.addConstr(3.05*x1 + 0.11*x2 + 7.99*x3 <= 57, "total_storage")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Blue Highlighters:", x1.x)
    print("Staplers:", x2.x)
    print("Cafeteria Chairs:", x3.x)
    print("Objective Value:", m.objVal)
else:
    print("No optimal solution found")
