
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='blue_highlighters', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='staplers', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='cafeteria_chairs', vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(5*x1 + 8*x2 + 3*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(3.05*x1 + 0.11*x2 + 7.99*x3 <= 67)
m.addConstr(0.11*x2 + 7.99*x3 <= 61)
m.addConstr(3.05*x1 + 7.99*x3 <= 22)
m.addConstr(3.05*x1 + 0.11*x2 + 7.99*x3 <= 57)

# Optimize
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Blue highlighters: ', x1.varValue)
    print('Staplers: ', x2.varValue)
    print('Cafeteria chairs: ', x3.varValue)
else:
    print('No optimal solution found')
