
import gurobipy as gp

# Create a new model
m = gp.Model("PlantOptimization")

# Create variables
chili_plants = m.addVar(vtype=gp.GRB.INTEGER, name="chili_plants")
carnations = m.addVar(vtype=gp.GRB.INTEGER, name="carnations")
sunflowers = m.addVar(vtype=gp.GRB.INTEGER, name="sunflowers")
peonies = m.addVar(vtype=gp.GRB.INTEGER, name="peonies")
agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")


# Set objective function
m.setObjective(3 * chili_plants + 5 * carnations + 9 * sunflowers + 2 * peonies + 9 * agave, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * chili_plants + 10 * carnations + 6 * sunflowers + 4 * peonies + 8 * agave <= 138, "water_need")
m.addConstr(6 * chili_plants + 10 * carnations + 9 * sunflowers + 4 * peonies + 8 * agave <= 87, "resilience_index")
m.addConstr(6 * sunflowers + 4 * peonies >= 19, "sunflowers_peonies_water")
m.addConstr(3 * chili_plants + 8 * agave >= 26, "chili_agave_water")
m.addConstr(10 * carnations + 6 * sunflowers >= 25, "carnations_sunflowers_water")
m.addConstr(9 * sunflowers + 4 * peonies >= 10, "sunflowers_peonies_resilience")
m.addConstr(9 * sunflowers + 8 * agave >= 11, "sunflowers_agave_resilience")
m.addConstr(6 * chili_plants + 4 * peonies >= 14, "chili_peonies_resilience")
m.addConstr(10 * carnations + 9 * sunflowers >= 5, "carnations_sunflowers_resilience")
m.addConstr(6 * chili_plants + 10 * carnations + 4 * peonies >= 17, "chili_carnations_peonies_resilience")
m.addConstr(6 * chili_plants + 10 * carnations + 8 * agave >= 17, "chili_carnations_agave_resilience")
m.addConstr(6 * chili_plants + 4 * peonies + 8 * agave >= 17, "chili_peonies_agave_resilience")
m.addConstr(6 * chili_plants + 9 * sunflowers + 4 * peonies >= 17, "chili_sunflowers_peonies_resilience")


m.addConstr(2 * chili_plants + 3 * carnations - 2 * peonies >= 0, "plant_combination")
m.addConstr(4 * peonies + 8 * agave <= 72, "peonies_agave_water_max")
m.addConstr(3 * chili_plants + 4 * peonies <= 52, "chili_peonies_water_max")
m.addConstr(10 * carnations + 4 * peonies <= 74, "carnations_peonies_water_max")
m.addConstr(3 * chili_plants + 10 * carnations <= 98, "chili_carnations_water_max")
m.addConstr(6 * sunflowers + 8 * agave <= 63, "sunflowers_agave_water_max")
m.addConstr(3 * chili_plants + 6 * sunflowers <= 42, "chili_sunflowers_water_max")
m.addConstr(3 * chili_plants + 6 * sunflowers + 4 * peonies <= 83, "chili_sunflowers_peonies_water_max")
m.addConstr(6 * sunflowers + 4 * peonies + 8 * agave <= 68, "sunflowers_peonies_agave_water_max")
m.addConstr(3 * chili_plants + 4 * peonies + 8 * agave <= 81, "chili_peonies_agave_water_max")
m.addConstr(3 * chili_plants + 10 * carnations + 6 * sunflowers <= 121, "chili_carnations_sunflowers_water_max")
m.addConstr(3 * chili_plants + 10 * carnations + 8 * agave <= 129, "chili_carnations_agave_water_max")
m.addConstr(10 * carnations + 6 * sunflowers + 4 * peonies <= 83, "carnations_sunflowers_peonies_water_max")
m.addConstr(10 * carnations + 6 * sunflowers + 8 * agave <= 115, "carnations_sunflowers_agave_water_max")
m.addConstr(3 * chili_plants + 10 * carnations + 6 * sunflowers + 4 * peonies + 8 * agave <= 115, "total_water_max")

m.addConstr(9 * sunflowers + 4 * peonies <= 59, "sunflowers_peonies_resilience_max")
m.addConstr(6 * chili_plants + 9 * sunflowers <= 23, "chili_sunflowers_resilience_max")
m.addConstr(6 * chili_plants + 9 * sunflowers + 4 * peonies <= 82, "chili_sunflowers_peonies_resilience_max")
m.addConstr(9 * sunflowers + 4 * peonies + 8 * agave <= 87, "sunflowers_peonies_agave_resilience_max")
m.addConstr(6 * chili_plants + 10 * carnations + 9 * sunflowers <= 21, "chili_carnations_sunflowers_resilience_max")
m.addConstr(6 * chili_plants + 10 * carnations + 4 * peonies <= 72, "chili_carnations_peonies_resilience_max")
m.addConstr(6 * chili_plants + 9 * sunflowers + 8 * agave <= 26, "chili_sunflowers_agave_resilience_max")
m.addConstr(6 * chili_plants + 10 * carnations + 9 * sunflowers + 4 * peonies + 8 * agave <= 26, "total_resilience_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chili Plants: {chili_plants.x}")
    print(f"Carnations: {carnations.x}")
    print(f"Sunflowers: {sunflowers.x}")
    print(f"Peonies: {peonies.x}")
    print(f"Agave: {agave.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

