
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanutbutter sandwiches")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls of cereal")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")


# Set objective function
m.setObjective(x0**2 + 3*x0*x1 + 3*x0*x2 + x0*x3 + 9*x1**2 + 8*x2*x3 + 4*x3**2 + 8*x0 + 6*x2 + 5*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.63*x1 + 0.71*x3 >= 26, "c1")
m.addConstr(0.91**2*x0**2 + 1.79**2*x2**2 <= 112, "c2")
m.addConstr(0.63*x1 + 1.79*x2 <= 63, "c3")
m.addConstr(0.63*x1 + 0.71*x3 <= 69, "c4")
m.addConstr(0.63*x1 + 1.79*x2 + 0.71*x3 <= 138, "c5")
m.addConstr(0.91*x0 + 0.63*x1 + 0.71*x3 <= 126, "c6")
m.addConstr(0.91*x0 + 0.63*x1 + 1.79*x2 <= 44, "c7")
m.addConstr(0.91*x0 + 0.63*x1 + 1.79*x2 + 0.71*x3 <= 44, "c8")



# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

