
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="peanutbutter_sandwiches", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="pickles", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="bowls_of_cereal", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x4 = m.addVar(name="ravioli", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
m.setObjective(1*x1**2 + 3*x1*x2 + 3*x1*x3 + x1*x4 + 9*x2**2 + 8*x3*x4 + 4*x4**2 + 8*x1 + 6*x3 + 5*x4, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(0.91*x1 + 0.63*x2 + 1.79*x3 + 0.71*x4 <= 162)
m.addConstr(0.63*x2 + 0.71*x4 >= 26)
m.addConstr(0.91**2*x1**2 + 1.79**2*x3**2 <= 112)
m.addConstr(0.63*x2 + 1.79*x3 <= 63)
m.addConstr(0.63*x2 + 0.71*x4 <= 69)
m.addConstr(0.63*x2 + 1.79*x3 + 0.71*x4 <= 138)
m.addConstr(0.91*x1 + 0.63*x2 + 0.71*x4 <= 126)
m.addConstr(0.91*x1 + 0.63*x2 + 1.79*x3 <= 44)
m.addConstr(0.91*x1 + 0.63*x2 + 1.79*x3 + 0.71*x4 <= 44)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Peanutbutter sandwiches: ", x1.varValue)
    print("Pickles: ", x2.varValue)
    print("Bowls of cereal: ", x3.varValue)
    print("Ravioli: ", x4.varValue)
else:
    print("The model is infeasible")
