
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
paul = m.addVar(vtype=GRB.INTEGER, name="paul")
bill = m.addVar(vtype=GRB.INTEGER, name="bill")
hank = m.addVar(vtype=GRB.INTEGER, name="hank")
george = m.addVar(vtype=GRB.INTEGER, name="george")
mary = m.addVar(vtype=GRB.INTEGER, name="mary")


# Set objective function
m.setObjective(1.59*paul**2 + 2.71*paul*bill + 8.71*paul*hank + 4.76*paul*george + 8.46*bill*hank + 9.89*bill*mary + 5.54*hank**2 + 2.64*hank*george + 9.0*hank*mary + 6.86*george*mary + 4.5*hank + 2.12*george + 5.37*mary, GRB.MINIMIZE)

# Add constraints
m.addConstr(14*bill**2 + 5*george**2 >= 17)
m.addConstr(5*george + 9*mary >= 17)
m.addConstr(14*paul + 16*hank >= 16)
m.addConstr(15*bill + 16*hank >= 27)
m.addConstr(14*paul**2 + 9*mary**2 >= 32)
m.addConstr(16*hank + 5*george >= 15)
m.addConstr(15*bill + 9*mary >= 36)
m.addConstr(14*paul**2 + 5*george**2 >= 38)
m.addConstr(14*paul + 15*bill + 16*hank + 5*george + 9*mary >= 38)
m.addConstr(1*george + 10*mary >= 23)
m.addConstr(11*hank**2 + 10*mary**2 >= 36)
m.addConstr(4*bill + 10*mary >= 39)
m.addConstr(4*paul + 1*george >= 14)
m.addConstr(4*bill + 11*hank >= 28)
m.addConstr(11*hank + 1*george >= 31)
m.addConstr(4*bill + 11*hank + 10*mary >= 38)
m.addConstr(4*paul + 4*bill + 1*george >= 38)
m.addConstr(11*hank + 1*george + 10*mary >= 38)
m.addConstr(4*bill**2 + 11*hank**2 + 10*mary**2 >= 27)
m.addConstr(4*paul**2 + 4*bill**2 + 1*george**2 >= 27)
m.addConstr(11*hank**2 + 1*george**2 + 10*mary**2 >= 27)
m.addConstr(4*bill + 11*hank + 10*mary >= 37)
m.addConstr(4*paul**2 + 4*bill**2 + 1*george**2 >= 37)
m.addConstr(11*hank + 1*george + 10*mary >= 37)
m.addConstr(4*paul + 4*bill + 11*hank + 1*george + 10*mary >= 37)
m.addConstr(-5*paul**2 + 1*hank**2 + 8*mary**2 >= 0)
m.addConstr(16*hank + 5*george <= 135)
m.addConstr(5*george**2 + 9*mary**2 <= 52)
m.addConstr(16*hank + 9*mary <= 108)
m.addConstr(14*paul + 15*bill <= 129)
m.addConstr(15*bill**2 + 5*george**2 <= 63)
m.addConstr(14*paul + 16*hank <= 165)
m.addConstr(15*bill + 16*hank <= 180)
m.addConstr(16*hank**2 + 5*george**2 + 9*mary**2 <= 154)
m.addConstr(4*bill + 10*mary <= 63)
m.addConstr(4*paul + 4*bill <= 186)
m.addConstr(4*bill + 1*george <= 182)
m.addConstr(4*bill + 11*hank <= 97)
m.addConstr(4*paul + 10*mary <= 41)
m.addConstr(4*paul + 11*hank <= 86)
m.addConstr(4*paul**2 + 1*george**2 <= 189)
m.addConstr(4*paul + 4*bill + 11*hank <= 160)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

