
import gurobi as gp

# Define variables
x0 = gp.Var(name="x0", lb=0, ub=None, vtype=gp.GRB.INTEGER)  # hours worked by Paul
x1 = gp.Var(name="x1", lb=0, ub=None, vtype=gp.GRB.INTEGER)  # hours worked by Bill
x2 = gp.Var(name="x2", lb=0, ub=None, vtype=gp.GRB.INTEGER)  # hours worked by Hank
x3 = gp.Var(name="x3", lb=0, ub=None, vtype=gp.GRB.INTEGER)  # hours worked by George
x4 = gp.Var(name="x4", lb=0, ub=None, vtype=gp.GRB.INTEGER)  # hours worked by Mary

# Objective function
m = gp.Model()
m.setObjective(1.59*x0**2 + 2.71*x0*x1 + 8.71*x0*x2 + 4.76*x0*x3 + 8.46*x1*x2 + 9.89*x1*x4 + 
               5.54*x2**2 + 2.64*x2*x3 + 9.0*x2*x4 + 6.86*x3*x4 + 4.5*x2 + 2.12*x3 + 5.37*x4, gp.GRB.MINIMIZE)

# Constraints (example of a few)
m.addConstr(x0 == 14)  # Paul's work quality rating
m.addConstr(4*x0 == 4)  # Paul's likelihood to quit index
m.addConstr(15*x1 == 15)  # Bill's work quality rating
m.addConstr(4*x1 == 4)   # Bill's likelihood to quit index

# Add more constraints here...

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("No optimal solution found")
