
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
bill = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")


# Set objective
m.setObjective(9 * peggy + 7 * bill + 5 * paul + 3 * jean + 4 * ringo, gp.GRB.MAXIMIZE)

# Add constraints
likelihood_to_quit = {
    'peggy': 11, 'bill': 1, 'paul': 8, 'jean': 10, 'ringo': 6
}
computer_competence = {
    'peggy': 1, 'bill': 11, 'paul': 4, 'jean': 10, 'ringo': 8
}
organization_score = {
    'peggy': 10, 'bill': 5, 'paul': 8, 'jean': 2, 'ringo': 4
}
paperwork_competence = {
    'peggy': 3, 'bill': 11, 'paul': 5, 'jean': 11, 'ringo': 1
}

m.addConstr(likelihood_to_quit['bill'] * bill + likelihood_to_quit['paul'] * paul >= 20)
m.addConstr(likelihood_to_quit['paul'] * paul + likelihood_to_quit['jean'] * jean >= 15)
# ... (add all other constraints similarly using the dictionaries above)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

