
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="mechanized_infantry_companies")
    x1 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")


    # Set objective function
    m.setObjective(9*x0**2 + 6*x0*x1 + 2*x1**2 + x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12*x0**2 + x1**2 >= 22, "c0")
    m.addConstr(18*x0 + 15*x1 >= 40, "c1")
    m.addConstr(14*x0 + 9*x1 >= 26, "c2")
    m.addConstr(17*x0**2 + 11*x1**2 >= 29, "c3")
    m.addConstr(-7*x0 + 6*x1 >= 0, "c4")
    m.addConstr(12*x0 + x1 <= 102, "c5")
    m.addConstr(18*x0 + 15*x1 <= 107, "c6")
    m.addConstr(14*x0 + 9*x1 <= 42, "c7")
    m.addConstr(17*x0 + 11*x1 <= 63, "c8")



    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('mechanized_infantry_companies:', x0.x)
        print('medical_platoons:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
