
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="mechanized_infantry_companies", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="medical_platoons", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(9*x1**2 + 6*x1*x2 + 2*x2**2 + x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(12*x1 + x2 <= 133, name="offensive_capability_rating")
m.addConstr(18*x1 + 15*x2 <= 162, name="logistical_capacity")
m.addConstr(14*x1 + 9*x2 <= 68, name="fun_factor")
m.addConstr(17*x1 + 11*x2 <= 95, name="defensive_capability_rating")
m.addConstr(12**2*x1**2 + x2**2 >= 22, name="total_offensive_capability_rating")
m.addConstr(18*x1 + 15*x2 >= 40, name="total_logistical_capacity")
m.addConstr(14*x1 + 9*x2 >= 26, name="total_fun_factor")
m.addConstr(17**2*x1**2 + 11**2*x2**2 >= 29, name="total_defensive_capability_rating")
m.addConstr(-7*x1 + 6*x2 >= 0, name="linear_constraint")
m.addConstr(12*x1 + x2 <= 102, name="total_offensive_capability_rating_2")
m.addConstr(18*x1 + 15*x2 <= 107, name="total_logistical_capacity_2")
m.addConstr(14*x1 + 9*x2 <= 42, name="total_fun_factor_2")
m.addConstr(17*x1 + 11*x2 <= 63, name="total_defensive_capability_rating_2")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Mechanized Infantry Companies: ", x1.varValue)
    print("Medical Platoons: ", x2.varValue)
else:
    print("The model is infeasible")
