
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")


# Set objective function
m.setObjective(4 * vitamin_c + 6 * vitamin_b3 + 8 * vitamin_k + 6 * vitamin_e + 5 * vitamin_b1 + 3 * vitamin_b12, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7.34 * vitamin_c + 11.69 * vitamin_e >= 24)
m.addConstr(2.84 * vitamin_b3 + 8.12 * vitamin_b1 >= 27)
m.addConstr(2.84 * vitamin_b3 + 8.22 * vitamin_k >= 16)
m.addConstr(8.12 * vitamin_b1 + 11.53 * vitamin_b12 >= 19)
m.addConstr(7.34 * vitamin_c + 8.12 * vitamin_b1 >= 20)
m.addConstr(11.69 * vitamin_e + 8.12 * vitamin_b1 >= 36)
m.addConstr(2.84 * vitamin_b3 + 11.53 * vitamin_b12 >= 13)
m.addConstr(2.84 * vitamin_b3 + 8.12 * vitamin_b1 + 11.53 * vitamin_b12 >= 40)
m.addConstr(2.84 * vitamin_b3 + 11.69 * vitamin_e + 11.53 * vitamin_b12 >= 40)
m.addConstr(11.69 * vitamin_e + 8.12 * vitamin_b1 + 11.53 * vitamin_b12 >= 40)
m.addConstr(7.34 * vitamin_c + 8.22 * vitamin_k + 8.12 * vitamin_b1 >= 40)
m.addConstr(8.22 * vitamin_k + 11.69 * vitamin_e + 8.12 * vitamin_b1 >= 40)
m.addConstr(2.84 * vitamin_b3 + 8.22 * vitamin_k + 11.69 * vitamin_e >= 40)
m.addConstr(7.34 * vitamin_c + 11.69 * vitamin_e + 11.53 * vitamin_b12 >= 40)
m.addConstr(7.34 * vitamin_c + 2.84 * vitamin_b3 + 11.53 * vitamin_b12 >= 40)
m.addConstr(8.22 * vitamin_k + 11.69 * vitamin_e + 11.53 * vitamin_b12 >= 40)
m.addConstr(7.34 * vitamin_c + 2.84 * vitamin_b3 + 8.12 * vitamin_b1 >= 40)
m.addConstr(7.34 * vitamin_c + 8.22 * vitamin_k + 11.69 * vitamin_e >= 40)
m.addConstr(2.84 * vitamin_b3 + 11.69 * vitamin_e + 8.12 * vitamin_b1 >= 40)


# ... (rest of the constraints, similarly added)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

