
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    cornichons = model.addVar(vtype=GRB.INTEGER, name="cornichons")
    cheeseburgers = model.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

    # Set objective function
    model.setObjective(7.98*cornichons**2 + 4.54*cheeseburgers, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*cornichons + 7*cheeseburgers >= 60, "c0")
    model.addConstr(11*cornichons + 19*cheeseburgers >= 44, "c1")
    model.addConstr(22*cornichons + 6*cheeseburgers >= 48, "c2")
    model.addConstr(9*cornichons**2 - 5*cheeseburgers**2 >= 0, "c3")
    model.addConstr(5*cornichons + 7*cheeseburgers <= 61, "c4")
    model.addConstr(11*cornichons + 19*cheeseburgers <= 141, "c5")
    model.addConstr(22*cornichons + 6*cheeseburgers <= 119, "c6")

    # Resource Constraints
    model.addConstr(5*cornichons <= 120, "rc0")
    model.addConstr(11*cornichons <= 167, "rc1")
    model.addConstr(22*cornichons <= 233, "rc2")
    model.addConstr(7*cheeseburgers <= 120, "rc3")
    model.addConstr(19*cheeseburgers <= 167, "rc4")
    model.addConstr(6*cheeseburgers <= 233, "rc5")


    model.addConstr(5*cornichons**2 + 7*cheeseburgers**2 >= 60, "c7")
    model.addConstr(11*cornichons**2 + 19*cheeseburgers**2 >= 44, "c8")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('cornichons:', cornichons.x)
        print('cheeseburgers:', cheeseburgers.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
