
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="cornichons", vtype=gurobi.GRB.INTEGER)  # cornichons
x2 = model.addVar(name="cheeseburgers")  # cheeseburgers

# Define the objective function
model.setObjective(7.98 * x1**2 + 4.54 * x2**2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(5 * x1 + 7 * x2 >= 60)  # carbohydrates
model.addConstr(5 * x1**2 + 7 * x2**2 >= 60)  # carbohydrates squared
model.addConstr(11 * x1 + 19 * x2 >= 44)  # sourness index
model.addConstr(11 * x1**2 + 19 * x2**2 >= 44)  # sourness index squared
model.addConstr(22 * x1 + 6 * x2 >= 48)  # healthiness rating
model.addConstr(9 * x1**2 - 5 * x2**2 >= 0)  # specific constraint
model.addConstr(5 * x1 + 7 * x2 <= 61)  # upper limit carbohydrates
model.addConstr(11 * x1 + 19 * x2 <= 141)  # upper limit sourness index
model.addConstr(22 * x1 + 6 * x2 <= 119)  # upper limit healthiness rating

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("cornichons: ", x1.varValue)
    print("cheeseburgers: ", x2.varValue)
else:
    print("The model is infeasible")
