
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(7*x0**2 + 6*x0*x1 + x0*x2 + 8*x0*x3 + 3*x1**2 + 3*x1*x2 + 4*x1*x3 + 3*x2**2 + 6*x2*x3 + 8*x3**2 + 2*x0 + 3*x1 + 5*x2 + 4*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x0 >= 11)
m.addConstr(1*x0 >= 1)
m.addConstr(14*x0 >= 14)
m.addConstr(10*x1 >= 10)
m.addConstr(2*x1 >= 2)
m.addConstr(17*x1 >= 17)
m.addConstr(17*x2 >= 17)
m.addConstr(17*x2 >= 17)
m.addConstr(16*x2 >= 16)
m.addConstr(19*x3 >= 19)
m.addConstr(18*x3 >= 18)
m.addConstr(13*x3 >= 13)
m.addConstr(11*x0 + 10*x1 >= 39)
m.addConstr(11*x0**2 + 19*x3**2 >= 61)
m.addConstr(10*x1 + 17*x2 >= 68)
m.addConstr(11*x0 + 10*x1 + 17*x2 + 19*x3 >= 68)
m.addConstr(1*x0 + 2*x1 >= 22)
m.addConstr(1*x0 + 17*x2 >= 14)
m.addConstr(17*x2 + 18*x3 >= 15)
m.addConstr(1*x0**2 + 2*x1**2 + 17*x2**2 >= 43)
m.addConstr(1*x0 + 17*x2 + 18*x3 >= 43)
m.addConstr(1*x0**2 + 2*x1**2 + 17*x2**2 >= 25)
m.addConstr(1*x0 + 17*x2 + 18*x3 >= 25)
m.addConstr(1*x0 + 2*x1 + 17*x2 + 18*x3 >= 25)
m.addConstr(17*x1 + 13*x3 >= 24)
m.addConstr(14*x0**2 + 17*x1**2 >= 19)
m.addConstr(14*x0 + 17*x1 + 16*x2 >= 40)
m.addConstr(14*x0 + 16*x2 + 13*x3 >= 40)
m.addConstr(14*x0**2 + 17*x1**2 + 16*x2**2 >= 27)
m.addConstr(14*x0**2 + 16*x2**2 + 13*x3**2 >= 27)
m.addConstr(14*x0 + 17*x1 + 16*x2 + 13*x3 >= 27)
m.addConstr(6*x0 - 5*x3 >= 0)
m.addConstr(11*x0 + 17*x2 + 19*x3 <= 299)
m.addConstr(10*x1 + 17*x2 + 19*x3 <= 247)
m.addConstr(x0 + 2*x1 <= 160)
m.addConstr(17*x2 + 18*x3 <= 115)
m.addConstr(14*x0 + 13*x3 <= 190)
m.addConstr(17*x1**2 + 16*x2**2 <= 164)


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

