
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="x2", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="x3", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="x4", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(7*x1**2 + 6*x1*x2 + x1*x3 + 8*x1*x4 + 3*x2**2 + 3*x2*x3 + 4*x2*x4 + 3*x3**2 + 6*x3*x4 + 8*x4**2 + 2*x1 + 3*x2 + 5*x3 + 4*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x1 <= 303)
m.addConstr(x1 <= 174)
m.addConstr(14*x1 <= 218)
m.addConstr(10*x2 <= 303)
m.addConstr(2*x2 <= 174)
m.addConstr(17*x2 <= 218)
m.addConstr(17*x3 <= 303)
m.addConstr(17*x3 <= 174)
m.addConstr(16*x3 <= 218)
m.addConstr(19*x4 <= 303)
m.addConstr(18*x4 <= 174)
m.addConstr(13*x4 <= 218)
m.addConstr(11*x1 + 10*x2 >= 39)
m.addConstr(11**2*x1**2 + 19**2*x4**2 >= 61)
m.addConstr(10*x2 + 17*x3 >= 68)
m.addConstr(11*x1 + 10*x2 + 17*x3 + 19*x4 >= 68)
m.addConstr(x1 + 2*x2 >= 22)
m.addConstr(x1 + 17*x3 >= 14)
m.addConstr(17*x3 + 18*x4 >= 15)
m.addConstr(x1**2 + x2**2 + 17**2*x3**2 >= 43)
m.addConstr(x1 + 17*x3 + 18*x4 >= 43)
m.addConstr(x1**2 + x2**2 + 17**2*x3**2 >= 25)
m.addConstr(x1 + 17*x3 + 18*x4 >= 25)
m.addConstr(x1 + x2 + x3 + x4 >= 25)
m.addConstr(17*x2 + 13*x4 >= 24)
m.addConstr(14**2*x1**2 + 17**2*x2**2 >= 19)
m.addConstr(14*x1 + 17*x2 + 16*x3 >= 40)
m.addConstr(14*x1 + 16*x3 + 13*x4 >= 40)
m.addConstr(14**2*x1**2 + 17**2*x2**2 + 16**2*x3**2 >= 27)
m.addConstr(14**2*x1**2 + 16**2*x3**2 + 13**2*x4**2 >= 27)
m.addConstr(14*x1 + 17*x2 + 16*x3 + 13*x4 >= 27)
m.addConstr(6*x1 - 5*x4 >= 0)
m.addConstr(11*x1 + 17*x3 + 19*x4 <= 299)
m.addConstr(10*x2 + 17*x3 + 19*x4 <= 247)
m.addConstr(x1 + 2*x2 <= 160)
m.addConstr(17*x3 + 18*x4 <= 115)
m.addConstr(14*x1 + 13*x4 <= 190)
m.addConstr(17**2*x2**2 + 16**2*x3**2 <= 164)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible or unbounded.")
