
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_George")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours_worked_by_Dale")


# Set objective function
m.setObjective(5.47*x0**2 + 1.32*x0*x1 + 4.27*x1**2 + 3.04*x0 + 1.6*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 15*x1 >= 37, "dollar_cost_constraint1")
m.addConstr(-3*x0 + 5*x1 >= 0, "constraint2")
m.addConstr(36*x0**2 + 225*x1**2 <= 44, "dollar_cost_constraint3")
m.addConstr(6*x0 + 15*x1 <= 44, "dollar_cost_constraint4")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('hours worked by George:', x0.x)
    print('hours worked by Dale:', x1.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status:', m.status)

