
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_George")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Dale")

# Objective function
m.setObjective(5.47*x1**2 + 1.32*x1*x2 + 4.27*x2**2 + 3.04*x1 + 1.6*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(-3*x1 + 5*x2 >= 0, name="constraint_1")
m.addConstr(6*x1 + 15*x2 >= 37, name="constraint_2")
m.addConstr(6*x1 + 15*x2 <= 44, name="constraint_3")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
