
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_George", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="hours_worked_by_Dale", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.47*x1**2 + 1.32*x1*x2 + 4.27*x2**2 + 3.04*x1 + 1.6*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6*x1 + 15*x2 >= 37, name="cost_constraint")
    model.addConstr(-3*x1 + 5*x2 >= 0, name="work_constraint")
    model.addConstr(36*x1**2 + 225*x2**2 <= 44, name="cost_squared_constraint")
    model.addConstr(x1 + x2 <= 44, name="total_hours_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by George: {x1.varValue}")
        print(f"Hours worked by Dale: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
