
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
    pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
    pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")

    # Set objective function
    m.setObjective(6.81 * bacon + 5.47 * pickles + 9.57 * pasta, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1 * bacon + 4 * pasta >= 55, "iron_bacon_pasta")
    m.addConstr(1 * bacon + 13 * pickles >= 97, "iron_bacon_pickles")
    m.addConstr(1 * bacon + 13 * pickles + 4 * pasta >= 74, "iron_total1")
    m.addConstr(9 * pickles + 11 * pasta >= 16, "sourness_pickles_pasta")
    m.addConstr(10 * bacon + 9 * pickles + 11 * pasta >= 16, "sourness_total")
    m.addConstr(5 * bacon - 3 * pasta >= 0, "bacon_pasta_ratio")
    m.addConstr(7 * bacon - 9 * pickles >= 0, "bacon_pickles_ratio")

    # Resource constraints
    m.addConstr(1 * bacon + 13 * pickles + 4 * pasta <= 296, "iron_limit")
    m.addConstr(10 * bacon + 9 * pickles + 11 * pasta <= 106, "sourness_limit")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Bacon: %g' % bacon.x)
        print('Pickles: %g' % pickles.x)
        print('Pasta: %g' % pasta.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
