
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="strips_of_bacon", lb=0)  # strips of bacon
    x1 = model.addVar(name="pickles", lb=0)  # pickles
    x2 = model.addVar(name="bowls_of_pasta", lb=0)  # bowls of pasta

    # Define the objective function
    model.setObjective(6.81 * x0 + 5.47 * x1 + 9.57 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1 * x0 + 4 * x2 >= 55)  # at least 55 milligrams of iron from strips of bacon and bowls of pasta
    model.addConstr(1 * x0 + 13 * x1 >= 97)  # at least 97 milligrams of iron from strips of bacon and pickles
    model.addConstr(1 * x0 + 13 * x1 + 4 * x2 >= 74)  # at least 74 milligrams of iron from all sources
    model.addConstr(9 * x1 + 11 * x2 >= 16)  # total combined sourness index from pickles and bowls of pasta
    model.addConstr(10 * x0 + 9 * x1 + 11 * x2 >= 16)  # total combined sourness index from all sources
    model.addConstr(5 * x0 - 3 * x2 >= 0)  
    model.addConstr(7 * x0 - 9 * x1 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Strips of bacon: ", x0.varValue)
        print("Pickles: ", x1.varValue)
        print("Bowls of pasta: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
