
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo")
laura = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura")
bobby = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby")
mary = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mary")
george = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george")
john = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="john")


# Set objective
m.setObjective(3*ringo**2 + 5*ringo*bobby + 8*ringo*mary + 9*ringo*george + 5*ringo*john + 3*laura**2 + 7*laura*george + 8*bobby**2 + 2*bobby*mary + 3*bobby*george + 4*bobby*john + 5*mary*george + 6*mary*john + 4*george**2 + 6*john**2 + 8*ringo + 2*bobby + 7*george, GRB.MAXIMIZE)

# Add constraints - Organization Score
m.addConstr(12*george + 4*john >= 34)
m.addConstr(13*mary + 12*george >= 29)
m.addConstr(19*laura + 4*john >= 34)
m.addConstr(3*ringo + 4*john >= 18)
m.addConstr(19*laura + 12*george >= 13)
# ... (Add all other organization score constraints similarly)
m.addConstr(3 * ringo**2 + 12 * george**2 <= 91)
# ... (Add all other upper bound organization score constraints similarly)


# Add constraints - Dollar Cost
m.addConstr(5*ringo + 13*george >= 18)
m.addConstr(8*bobby + 4*mary >= 22)
# ... (Add all other dollar cost constraints similarly)


# Add constraints - Paperwork Competence
m.addConstr(16*bobby + 19*george >= 27)
m.addConstr(19*george + 2*john >= 69)
# ... (Add all other paperwork competence constraints similarly)


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print variable values
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)

