
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
hamburgers = model.addVar(vtype=gp.GRB.INTEGER, name="hamburgers")
oranges = model.addVar(vtype=gp.GRB.INTEGER, name="oranges")
ramen = model.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_instant_ramen")

# Set objective function
model.setObjective(6 * hamburgers + 7 * oranges + 9 * ramen, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * hamburgers + 11 * oranges + 1 * ramen <= 114, "carbohydrate_limit")
model.addConstr(4 * hamburgers + 7 * oranges + 9 * ramen <= 132, "tastiness_limit")
model.addConstr(8 * hamburgers + 11 * oranges >= 29, "carbohydrate_hamburgers_oranges")
model.addConstr(8 * hamburgers + 1 * ramen >= 30, "carbohydrate_hamburgers_ramen")
model.addConstr(8 * hamburgers + 11 * oranges + 1 * ramen >= 30, "carbohydrate_total")
model.addConstr(4 * hamburgers + 7 * oranges >= 37, "tastiness_hamburgers_oranges")
model.addConstr(7 * oranges + 9 * ramen >= 39, "tastiness_oranges_ramen")
model.addConstr(4 * hamburgers + 7 * oranges + 9 * ramen >= 22, "tastiness_total")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hamburgers: {hamburgers.x}")
    print(f"Oranges: {oranges.x}")
    print(f"Bowls of instant ramen: {ramen.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

