
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hamburgers")
x1 = m.addVar(vtype=GRB.INTEGER, name="oranges")
x2 = m.addVar(vtype=GRB.INTEGER, name="bowls_of_instant_ramen")

# Set the objective function
m.setObjective(6*x0 + 7*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x0 + 11*x1 >= 29, "carbs_hamburgers_oranges")
m.addConstr(8*x0 + x2 >= 30, "carbs_hamburgers_ramen")
m.addConstr(8*x0 + 11*x1 + x2 >= 30, "total_carbs")
m.addConstr(4*x0 + 7*x1 >= 37, "tastiness_hamburgers_oranges")
m.addConstr(7*x1 + 9*x2 >= 39, "tastiness_oranges_ramen")
m.addConstr(4*x0 + 7*x1 + 9*x2 >= 22, "total_tastiness")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"hamburgers: {x0.x}")
    print(f"oranges: {x1.x}")
    print(f"bowls of instant ramen: {x2.x}")
else:
    print("No optimal solution found.")
