
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, name=["ham sandwiches", "chicken thighs", "rotisserie chickens", "steaks", "strips of bacon", "cantaloupes"])


# Set objective function
m.setObjective(6.97*x[0]*x[1] + 1.95*x[0]*x[2] + 4.26*x[0]*x[3] + 3.64*x[0]*x[4] + 4.75*x[0]*x[5] + 4.24*x[1]**2 + 9.26*x[1]*x[2] + 6.36*x[2]**2 + 4.49*x[3]**2 + 1.52*x[3]*x[4] + 7.28*x[4]*x[5] + 7.75*x[1] + 3.98*x[3] + 6.93*x[4] + 5.3*x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x[0] + 10*x[1] + 10*x[2] + 14*x[3] + 6*x[4] + 12*x[5] <= 178, "protein_constraint")
m.addConstr((11*x[0])**2 + (10*x[2])**2 <= 158, "protein_constraint1")
m.addConstr((10*x[1])**2 + (6*x[4])**2 <= 152, "protein_constraint2")
m.addConstr(6*x[4] + 12*x[5] <= 36, "protein_constraint3")
m.addConstr(11*x[0] + 10*x[1] <= 44, "protein_constraint4")
m.addConstr(10*x[2] + 12*x[5] <= 53, "protein_constraint5")
m.addConstr(11*x[0] + 14*x[3] <= 102, "protein_constraint6")
m.addConstr(10*x[2] + 6*x[4] <= 168, "protein_constraint7")
m.addConstr((10*x[1])**2 + (10*x[2])**2 <= 51, "protein_constraint8")
m.addConstr(10*x[1] + 14*x[3] <= 118, "protein_constraint9")
m.addConstr((10*x[1])**2 + (12*x[5])**2 <= 171, "protein_constraint10")
m.addConstr(11*x[0] + 10*x[1] + 10*x[2] + 14*x[3] + 6*x[4] + 12*x[5] <= 171, "protein_constraint11")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

