
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="ham_sandwiches", lb=0)  # No lower bound specified, assuming 0
x2 = m.addVar(name="chicken_thighs", lb=0)
x3 = m.addVar(name="rotisserie_chickens", lb=0)
x4 = m.addVar(name="steaks", lb=0)
x5 = m.addVar(name="strips_of_bacon", lb=0)
x6 = m.addVar(name="cantaloupes", lb=0)

# Define the objective function
m.setObjective(6.97*x1*x2 + 1.95*x1*x3 + 4.26*x1*x4 + 3.64*x1*x5 + 4.75*x1*x6 + 
               4.24*x2**2 + 9.26*x2*x3 + 6.36*x3**2 + 4.49*x4**2 + 1.52*x4*x5 + 
               7.28*x5*x6 + 7.75*x2 + 3.98*x4 + 6.93*x5 + 5.3*x6, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(11*x1 + 10*x2 + 10*x3 + 14*x4 + 6*x5 + 12*x6 <= 178)
m.addConstr(121*x1**2 + 100*x3**2 <= 158)
m.addConstr(100*x2**2 + 36*x5**2 <= 152)
m.addConstr(6*x5 + 12*x6 <= 36)
m.addConstr(11*x1 + 10*x2 <= 44)
m.addConstr(10*x3 + 12*x6 <= 53)
m.addConstr(11*x1 + 14*x4 <= 102)
m.addConstr(10*x3 + 6*x5 <= 168)
m.addConstr(100*x2**2 + 100*x3**2 <= 51)
m.addConstr(10*x2 + 14*x4 <= 118)
m.addConstr(100*x2**2 + 144*x6**2 <= 171)
m.addConstr(11*x1 + 10*x2 + 10*x3 + 14*x4 + 6*x5 + 12*x6 <= 171)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("ham sandwiches: ", x1.varValue)
    print("chicken thighs: ", x2.varValue)
    print("rotisserie chickens: ", x3.varValue)
    print("steaks: ", x4.varValue)
    print("strips of bacon: ", x5.varValue)
    print("cantaloupes: ", x6.varValue)
else:
    print("The model is infeasible")
