
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
x1 = m.addVar(vtype=GRB.INTEGER, name="lemons")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cherry_pies")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="ravioli")
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="hamburgers")

# Set the objective function
m.setObjective(1*x0 + 9*x1 + 8*x2 + 8*x3 + 6*x4, GRB.MAXIMIZE)

# Add constraints (example with two constraints)
m.addConstr(14*x3 + 11*x4 >= 44, "calcium_ravioli_hamburgers")
m.addConstr(16*x0 + 19*x1 + 20*x2 >= 41, "umami_index")

# Add all other constraints here...

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print("%s = %g" % (v.varName, v.x))
else:
    print("No optimal solution found")
