
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
ingredients = {
    0: 'grams of fiber',
    1: 'milligrams of zinc',
    2: 'milligrams of vitamin E',
    3: 'milligrams of magnesium',
    4: 'milligrams of vitamin B12',
    5: 'milligrams of vitamin K',
    6: 'milligrams of vitamin B9',
    7: 'milligrams of vitamin B4'
}
x = {}
for i in ingredients:
    x[i] = m.addVar(lb=0, name=ingredients[i])


# Set objective function
m.setObjective(4*x[0] + 3*x[1] + 4*x[2] + 7*x[3] + 5*x[4] + 7*x[5] + 5*x[6] + 3*x[7], gp.GRB.MAXIMIZE)

# Add cardiovascular support constraints
cardiovascular_support = {
    'r0': {'upper_bound': 250, 0: 2, 1: 8, 2: 5, 3: 8, 4: 5, 5: 6, 6: 11, 7: 6}
}
m.addConstr(2*x[0] + 8*x[1] + 5*x[2] + 8*x[3] + 5*x[4] + 6*x[5] + 11*x[6] + 6*x[7] <= cardiovascular_support['r0']['upper_bound'], "cardiovascular_support")


# Add kidney support constraints
kidney_support = {
    'r1': {'upper_bound': 421, 0: 5, 1: 1, 2: 11, 3: 8, 4: 6, 5: 3, 6: 6, 7: 5}
}
m.addConstr(5*x[0] + 1*x[1] + 11*x[2] + 8*x[3] + 6*x[4] + 3*x[5] + 6*x[6] + 5*x[7] <= kidney_support['r1']['upper_bound'], "kidney_support")


# Add all other constraints (simplified and deduplicated)
m.addConstr(8*x[1] + 6*x[5] >= 15)
m.addConstr(8*x[3] + 6*x[7] >= 15)
m.addConstr(8*x[1] + 5*x[2] + 6*x[7] >= 31)  # Highest lower bound
m.addConstr(2*x[0] + 5*x[4] + 11*x[6] >= 31) # Highest lower bound
m.addConstr(5*x[2] + 8*x[3] + 5*x[4] >= 30) # Highest lower bound
m.addConstr(2*x[0] + 8*x[3] + 11*x[6] >= 31) # Highest lower bound
m.addConstr(2*x[0] + 5*x[4] + 6*x[7] >= 31) # Highest lower bound
m.addConstr(2*x[0] + 8*x[3] + 6*x[5] >= 30) # Highest lower bound
m.addConstr(5*x[2] + 8*x[3] + 6*x[7] >= 30) # Highest lower bound
m.addConstr(8*x[1] + 5*x[2] + 11*x[6] >= 30) # Highest lower bound
m.addConstr(5*x[2] + 8*x[3] + 6*x[5] >= 30) # Highest lower bound
m.addConstr(8*x[1] + 8*x[3] + 11*x[6] >= 31) # Highest lower bound
m.addConstr(2*x[0] + 8*x[1] + 6*x[7] >= 31) # Highest lower bound
m.addConstr(2*x[0] + 8*x[3] + 6*x[7] >= 31) # Highest lower bound
m.addConstr(8*x[1] + 11*x[6] + 6*x[7] >= 31) # Highest lower bound
m.addConstr(5*x[0] + 6*x[4] >= 47)
m.addConstr(6*x[4] + 3*x[5] >= 52)
m.addConstr(1*x[1] + 6*x[4] >= 36)
m.addConstr(3*x[5] + 5*x[7] >= 44)
m.addConstr(5*x[0] + 8*x[3] >= 19)
m.addConstr(8*x[3] + 6*x[4] >= 30)
m.addConstr(5*x[0] + 3*x[5] >= 35)
m.addConstr(8*x[3] + 3*x[5] + 6*x[6] >= 52) # Highest lower bound


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

