
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
chives = m.addVar(vtype=gp.GRB.INTEGER, name="chives")
agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")
squash_plants = m.addVar(vtype=gp.GRB.INTEGER, name="squash_plants")
carrots = m.addVar(vtype=gp.GRB.INTEGER, name="carrots")


# Set objective function
m.setObjective(6*chives**2 + 7*chives*carrots + 4*agave*squash_plants + 7*squash_plants + 2*carrots, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*chives + 8*agave + 7*squash_plants + 11*carrots <= 154, "c0")
m.addConstr(12*chives + 13*agave + 11*squash_plants + 6*carrots <= 103, "c1")
m.addConstr(10*chives + 4*agave + 14*squash_plants + 6*carrots <= 215, "c2")
m.addConstr(8*agave + 11*carrots >= 28, "c3")
m.addConstr(12*chives + 13*agave + 11*squash_plants >= 16, "c4")
m.addConstr(12*chives**2 + 13*agave**2 + 6*carrots**2 >= 16, "c5")
m.addConstr(12*chives**2 + 13*agave**2 + 11*squash_plants**2 >= 25, "c6")
m.addConstr(12*chives**2 + 13*agave**2 + 6*carrots**2 >= 25, "c7")
m.addConstr(10*chives**2 + 6*carrots**2 >= 47, "c8")
m.addConstr(14*squash_plants + 6*carrots >= 22, "c9")
m.addConstr(4*agave + 14*squash_plants >= 21, "c10")
m.addConstr(4*agave**2 + 14*squash_plants**2 + 6*carrots**2 >= 33, "c11")
m.addConstr(-4*squash_plants**2 + carrots**2 >= 0, "c12")
m.addConstr(14*chives**2 + 7*squash_plants**2 <= 69, "c13")
m.addConstr(14*chives + 8*agave <= 42, "c14")
m.addConstr(14*chives + 11*carrots <= 92, "c15")
m.addConstr(7*squash_plants + 11*carrots <= 62, "c16")
m.addConstr(14*chives**2 + 8*agave**2 + 11*carrots**2 <= 135, "c17")
m.addConstr(14*chives + 8*agave + 7*squash_plants + 11*carrots <= 135, "c18")
m.addConstr(12*chives + 11*squash_plants <= 71, "c19")
m.addConstr(13*agave + 6*carrots <= 77, "c20")
m.addConstr(12*chives + 13*agave + 11*squash_plants <= 45, "c21")
m.addConstr(12*chives + 13*agave + 11*squash_plants + 6*carrots <= 45, "c22")
m.addConstr(10*chives + 4*agave <= 120, "c23")
m.addConstr(14*squash_plants + 6*carrots <= 161, "c24")
m.addConstr(4*agave + 14*squash_plants <= 56, "c25")
m.addConstr(10*chives**2 + 4*agave**2 + 14*squash_plants**2 <= 160, "c26")
m.addConstr(10*chives + 14*squash_plants + 6*carrots <= 174, "c27")
m.addConstr(10*chives + 4*agave + 14*squash_plants + 6*carrots <= 174, "c28")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

