
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="chives", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="agave", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="squash_plants", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="carrots", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(6 * x1 ** 2 + 7 * x1 * x4 + 4 * x2 * x3 + 7 * x3 + 2 * x4, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(14 * x1 <= 154)
m.addConstr(12 * x1 <= 103)
m.addConstr(10 * x1 <= 215)
m.addConstr(8 * x2 <= 154)
m.addConstr(13 * x2 <= 103)
m.addConstr(4 * x2 <= 215)
m.addConstr(7 * x3 <= 154)
m.addConstr(11 * x3 <= 103)
m.addConstr(14 * x3 <= 215)
m.addConstr(11 * x4 <= 154)
m.addConstr(6 * x4 <= 103)
m.addConstr(6 * x4 <= 215)
m.addConstr(8 * x2 + 11 * x4 >= 28)
m.addConstr(12 * x1 + 13 * x2 + 11 * x3 >= 16)
m.addConstr((12 * x1) ** 2 + (13 * x2) ** 2 + (6 * x4) ** 2 >= 16)
m.addConstr((12 * x1) ** 2 + (13 * x2) ** 2 + (11 * x3) ** 2 >= 25)
m.addConstr((12 * x1) ** 2 + (13 * x2) ** 2 + (6 * x4) ** 2 >= 25)
m.addConstr((10 * x1) ** 2 + (6 * x4) ** 2 >= 47)
m.addConstr(14 * x3 + 6 * x4 >= 22)
m.addConstr(4 * x2 + 14 * x3 >= 21)
m.addConstr((4 * x2) ** 2 + (14 * x3) ** 2 + (6 * x4) ** 2 >= 33)
m.addConstr(-4 * x3 ** 2 + x4 ** 2 >= 0)
m.addConstr((14 * x1) ** 2 + (7 * x3) ** 2 <= 69)
m.addConstr(14 * x1 + 8 * x2 <= 42)
m.addConstr(14 * x1 + 11 * x4 <= 92)
m.addConstr(7 * x3 + 11 * x4 <= 62)
m.addConstr((14 * x1) ** 2 + (8 * x2) ** 2 + (11 * x4) ** 2 <= 135)
m.addConstr(14 * x1 + 8 * x2 + 7 * x3 + 11 * x4 <= 135)
m.addConstr(12 * x1 + 11 * x3 <= 71)
m.addConstr(13 * x2 + 6 * x4 <= 77)
m.addConstr(12 * x1 + 13 * x2 + 11 * x3 <= 45)
m.addConstr(12 * x1 + 13 * x2 + 11 * x3 + 6 * x4 <= 45)
m.addConstr(10 * x1 + 4 * x2 <= 120)
m.addConstr(14 * x3 + 6 * x4 <= 161)
m.addConstr(4 * x2 + 14 * x3 <= 56)
m.addConstr((10 * x1) ** 2 + (4 * x2) ** 2 + (14 * x3) ** 2 <= 160)
m.addConstr(10 * x1 + 14 * x3 + 6 * x4 <= 174)
m.addConstr(10 * x1 + 4 * x2 + 14 * x3 + 6 * x4 <= 174)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chives: ", x1.varValue)
    print("Agave: ", x2.varValue)
    print("Squash Plants: ", x3.varValue)
    print("Carrots: ", x4.varValue)
else:
    print("The model is infeasible")
