
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(name="grams_of_protein")
x1 = m.addVar(name="milligrams_of_vitamin_B3")
x2 = m.addVar(name="grams_of_fiber")
x3 = m.addVar(name="milligrams_of_vitamin_B6")
x4 = m.addVar(name="milligrams_of_vitamin_C")


# Set objective function
m.setObjective(3.55*x0**2 + 5.95*x0*x1 + 5.45*x1**2 + 3.11*x2*x4 + 8.58*x3*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 19*x1 + 15*x2 + 5*x3 + 11*x4 <= 167, "r0")
m.addConstr(8*x0 + 18*x1 + 10*x2 + 17*x3 + 4*x4 <= 134, "r1")
m.addConstr(13*x0 + 3*x1 + 10*x2 + 18*x3 + 3*x4 <= 315, "r2")
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

