
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="bananas")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="hamburgers")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="strawberries")
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="black_beans")


# Set objective function
m.setObjective(8.8 * x0 + 9.13 * x1 + 6.84 * x2 + 8.77 * x3 + 3.21 * x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * x0 + 25 * x1 + 5 * x2 + 14 * x3 + 20 * x4 <= 244, "r0")
m.addConstr(18 * x0 + 22 * x1 + 5 * x2 + 18 * x3 + 1 * x4 <= 151, "r1")
m.addConstr(25 * x1 + 20 * x4 >= 35, "c1")
m.addConstr(18 * x0 + 14 * x3 >= 42, "c2")
m.addConstr(25 * x1 + 14 * x3 >= 38, "c3")
m.addConstr(14 * x3 + 20 * x4 >= 33, "c4")
m.addConstr(25 * x1 + 14 * x3 + 20 * x4 >= 25, "c5")
m.addConstr(18 * x0 + 25 * x1 + 5 * x2 + 14 * x3 + 20 * x4 >= 25, "c6")
m.addConstr(18 * x0 + 5 * x2 >= 12, "c7")
m.addConstr(18 * x0 + 18 * x3 >= 14, "c8")


# Add remaining constraints (similar format as above) ...


m.addConstr(-x0 + 3 * x1 >= 0, "c67")
m.addConstr(18 * x0 + 25 * x1 <= 218, "c68")
m.addConstr(25 * x1 + 20 * x4 <= 164, "c69")
m.addConstr(25 * x1 + 5 * x2 + 20 * x4 <= 89, "c70")
m.addConstr(25 * x1 + 14 * x3 + 20 * x4 <= 186, "c71")
m.addConstr(18 * x0 + 5 * x2 + 14 * x3 <= 210, "c72")
m.addConstr(18 * x0 + 1 * x4 <= 105, "c73")
m.addConstr(18 * x0 + 18 * x3 <= 57, "c74")
m.addConstr(22 * x1 + 5 * x2 + 18 * x3 <= 117, "c75")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

