
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, name="vitamin_c")  # milligrams of vitamin C
    x1 = m.addVar(lb=0, name="vitamin_b7") # milligrams of vitamin B7


    # Set objective function
    m.setObjective(3.56 * x0 + 9.33 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5.67 * x0 + 6.06 * x1 >= 84, "c1")
    m.addConstr(0.73 * x0 + 4.16 * x1 >= 21, "c2")
    m.addConstr(0.37 * x0 + 1.26 * x1 >= 48, "c3")
    m.addConstr(3.56 * x0 + 1.87 * x1 >= 58, "c4")
    m.addConstr(5 * x0 - 3 * x1 >= 0, "c5")
    m.addConstr(5.67 * x0 + 6.06 * x1 <= 248, "c6")
    m.addConstr(0.73 * x0 + 4.16 * x1 <= 90, "c7")
    m.addConstr(0.37 * x0 + 1.26 * x1 <= 128, "c8")
    m.addConstr(3.56 * x0 + 1.87 * x1 <= 127, "c9")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective value: %g' % m.objVal)
        print('milligrams of vitamin C: %g' % x0.x)
        print('milligrams of vitamin B7: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
