
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_C", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="milligrams_of_vitamin_B7", lb=0)  # Assuming non-negative

    # Define the objective function
    model.setObjective(3.56 * x1 + 9.33 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5.67 * x1 + 6.06 * x2 >= 84)
    model.addConstr(0.73 * x1 + 4.16 * x2 >= 21)
    model.addConstr(0.37 * x1 + 1.26 * x2 >= 48)
    model.addConstr(3.56 * x1 + 1.87 * x2 >= 58)
    model.addConstr(5 * x1 - 3 * x2 >= 0)
    model.addConstr(5.67 * x1 + 6.06 * x2 <= 248)
    model.addConstr(0.73 * x1 + 4.16 * x2 <= 90)
    model.addConstr(0.37 * x1 + 1.26 * x2 <= 128)
    model.addConstr(3.56 * x1 + 1.87 * x2 <= 127)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {x1.varValue}")
        print(f"Milligrams of vitamin B7: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
