
import gurobipy as gp

# Create a new model
m = gp.Model("work_hour_optimization")

# Create variables
bobby = m.addVar(vtype=gp.GRB.INTEGER, name="bobby")
dale = m.addVar(vtype=gp.GRB.INTEGER, name="dale")
george = m.addVar(vtype=gp.GRB.INTEGER, name="george")
jean = m.addVar(vtype=gp.GRB.INTEGER, name="jean")
paul = m.addVar(vtype=gp.GRB.INTEGER, name="paul")


# Set objective function
m.setObjective(3.31 * bobby + 6.55 * dale + 6.49 * george + 4.5 * jean + 8.58 * paul, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(22 * bobby + 19 * george + 19 * jean >= 29)
m.addConstr(20 * dale + 19 * george + 35 * paul >= 29)
m.addConstr(19 * george + 19 * jean + 35 * paul >= 29)
m.addConstr(22 * bobby + 19 * george + 19 * jean >= 25)
m.addConstr(20 * dale + 19 * george + 35 * paul >= 25)
m.addConstr(19 * george + 19 * jean + 35 * paul >= 25)
m.addConstr(22 * bobby + 19 * george + 19 * jean >= 47)
m.addConstr(20 * dale + 19 * george + 35 * paul >= 47)
m.addConstr(19 * george + 19 * jean + 35 * paul >= 47)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Bobby:', bobby.x)
    print('Dale:', dale.x)
    print('George:', george.x)
    print('Jean:', jean.x)
    print('Paul:', paul.x)

elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

