
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
    intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
    security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
    system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")

    # Set objective function
    m.setObjective(7*patches_per_day + 6*intrusion_analysts + 5*security_engineers + 4*system_administrators, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(20*patches_per_day + 14*intrusion_analysts >= 40)
    m.addConstr(20*patches_per_day + 14*system_administrators >= 58)
    m.addConstr(14*intrusion_analysts + 2*security_engineers + 14*system_administrators >= 57)
    m.addConstr(20*patches_per_day + 14*intrusion_analysts + 2*security_engineers + 14*system_administrators >= 57)
    m.addConstr(5*intrusion_analysts + 8*system_administrators >= 51)
    m.addConstr(5*patches_per_day + 5*intrusion_analysts + 21*security_engineers + 8*system_administrators >= 51)
    m.addConstr(14*security_engineers + 5*system_administrators >= 63)
    m.addConstr(15*intrusion_analysts + 14*security_engineers >= 60)
    m.addConstr(18*patches_per_day + 5*system_administrators >= 62)
    m.addConstr(15*intrusion_analysts + 5*system_administrators >= 61)
    m.addConstr(18*patches_per_day + 14*security_engineers >= 51)
    m.addConstr(18*patches_per_day + 15*intrusion_analysts >= 49)
    m.addConstr(18*patches_per_day + 15*intrusion_analysts + 14*security_engineers + 5*system_administrators >= 49)
    m.addConstr(10*patches_per_day - 5*security_engineers >= 0)
    m.addConstr(-1*security_engineers + 9*system_administrators >= 0)
    m.addConstr(20*patches_per_day + 2*security_engineers <= 265)
    m.addConstr(14*intrusion_analysts + 2*security_engineers <= 145)
    m.addConstr(20*patches_per_day + 14*intrusion_analysts <= 79)
    m.addConstr(20*patches_per_day + 14*system_administrators <= 97)
    m.addConstr(20*patches_per_day + 14*intrusion_analysts + 14*system_administrators <= 262)
    m.addConstr(5*intrusion_analysts + 21*security_engineers + 8*system_administrators <= 279)
    m.addConstr(15*intrusion_analysts + 5*system_administrators <= 96)

    # Resource Constraints
    m.addConstr(20*patches_per_day + 14*intrusion_analysts + 2*security_engineers + 14*system_administrators <= 313)
    m.addConstr(5*patches_per_day + 5*intrusion_analysts + 21*security_engineers + 8*system_administrators <= 343)
    m.addConstr(18*patches_per_day + 15*intrusion_analysts + 14*security_engineers + 5*system_administrators <= 259)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
