
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='patches_per_day', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='intrusion_analysts', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='security_engineers', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='system_administrators', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7 * x1 + 6 * x2 + 5 * x3 + 4 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x1 + 14 * x2 + 2 * x3 + 14 * x4 <= 313)
    model.addConstr(5 * x1 + 5 * x2 + 21 * x3 + 8 * x4 <= 343)
    model.addConstr(18 * x1 + 15 * x2 + 14 * x3 + 5 * x4 <= 259)
    model.addConstr(20 * x1 + 14 * x2 >= 40)
    model.addConstr(20 * x1 + 14 * x4 >= 58)
    model.addConstr(14 * x2 + 2 * x3 + 14 * x4 >= 57)
    model.addConstr(20 * x1 + 14 * x2 + 2 * x3 + 14 * x4 >= 57)
    model.addConstr(5 * x2 + 8 * x4 >= 51)
    model.addConstr(5 * x1 + 5 * x2 + 21 * x3 + 8 * x4 >= 51)
    model.addConstr(14 * x3 + 5 * x4 >= 63)
    model.addConstr(15 * x2 + 14 * x3 >= 60)
    model.addConstr(18 * x1 + 5 * x4 >= 62)
    model.addConstr(15 * x2 + 5 * x4 >= 61)
    model.addConstr(18 * x1 + 14 * x3 >= 51)
    model.addConstr(18 * x1 + 15 * x2 >= 49)
    model.addConstr(18 * x1 + 15 * x2 + 14 * x3 + 5 * x4 >= 49)
    model.addConstr(10 * x1 - 5 * x3 >= 0)
    model.addConstr(-x3 + 9 * x4 >= 0)
    model.addConstr(20 * x1 + 2 * x3 <= 265)
    model.addConstr(14 * x2 + 2 * x3 <= 145)
    model.addConstr(20 * x1 + 14 * x2 <= 79)
    model.addConstr(20 * x1 + 14 * x4 <= 97)
    model.addConstr(20 * x1 + 14 * x2 + 14 * x4 <= 262)
    model.addConstr(5 * x2 + 21 * x3 + 8 * x4 <= 279)
    model.addConstr(15 * x2 + 5 * x4 <= 96)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('patches_per_day: ', x1.varValue)
        print('intrusion_analysts: ', x2.varValue)
        print('security_engineers: ', x3.varValue)
        print('system_administrators: ', x4.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
