
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Paul', lb=0)  # No upper bound given
    x2 = model.addVar(name='hours_worked_by_Hank', lb=0)   # No upper bound given
    x3 = model.addVar(name='hours_worked_by_John', lb=0)   # No upper bound given
    x4 = model.addVar(name='hours_worked_by_Mary', lb=0)   # No upper bound given

    # Define the objective function
    model.setObjective(3.68*x1 + 2.07*x2 + 5.86*x3 + 3.14*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(8*x1 + 4*x2 >= 12)
    model.addConstr(8*x1 + 13*x3 >= 11)
    model.addConstr(13*x3 + 7*x4 >= 13)
    model.addConstr(4*x2 + 7*x4 >= 30)
    model.addConstr(4*x2 + 7*x4 <= 127)
    model.addConstr(13*x3 + 7*x4 <= 34)
    model.addConstr(8*x1 + 4*x2 <= 96)
    model.addConstr(4*x2 + 13*x3 + 7*x4 <= 38)
    model.addConstr(8*x1 + 4*x2 + 13*x3 + 7*x4 <= 38)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by Paul: ', x1.varValue)
        print('Hours worked by Hank: ', x2.varValue)
        print('Hours worked by John: ', x3.varValue)
        print('Hours worked by Mary: ', x4.varValue)
    else:
        print('No optimal solution found')

optimize_problem()
