
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="George")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")
bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary")
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")


# Set objective
model.setObjective(6.15 * george + 4.52 * john + 6.66 * laura + 7.61 * bobby + 1.6 * mary + 4.75 * hank + 6.55 * paul, gp.GRB.MAXIMIZE)

# Resource and attribute data
resources = {
    'r0': {'description': 'computer competence rating', 'upper_bound': 747, 'George': 9, 'John': 8, 'Laura': 24, 'Bobby': 34, 'Mary': 34, 'Hank': 3, 'Paul': 20},
    'r1': {'description': 'likelihood to quit index', 'upper_bound': 734, 'George': 33, 'John': 20, 'Laura': 4, 'Bobby': 13, 'Mary': 1, 'Hank': 11, 'Paul': 5},
    'r2': {'description': 'work quality rating', 'upper_bound': 804, 'George': 14, 'John': 17, 'Laura': 8, 'Bobby': 9, 'Mary': 21, 'Hank': 25, 'Paul': 15},
    'r3': {'description': 'organization score', 'upper_bound': 752, 'George': 24, 'John': 10, 'Laura': 26, 'Bobby': 15, 'Mary': 3, 'Hank': 23, 'Paul': 2},
    'r4': {'description': 'paperwork competence rating', 'upper_bound': 685, 'George': 8, 'John': 13, 'Laura': 17, 'Bobby': 18, 'Mary': 35, 'Hank': 4, 'Paul': 24}
}
variables = {'George': george, 'John': john, 'Laura': laura, 'Bobby': bobby, 'Mary': mary, 'Hank': hank, 'Paul': paul}

# Add constraints from the JSON "constraints" field.  These are already in symbolic form.
constraints_json = {
    "24 * x2 + 34 * x3 >= 95",
    "9 * x0 + 3 * x5 >= 41",
    "8 * x1 + 34 * x4 >= 104",
    "24 * x2 + 20 * x6 >= 88",
    "8 * x1 + 34 * x3 >= 42",
    "8 * x1 + 24 * x2 >= 50",
    "9 * x0 + 8 * x1 >= 37",
    "24 * x2 + 34 * x3 + 34 * x4 >= 93",
    "9 * x0 + 8 * x1 + 3 * x5 >= 93",
    "24 * x2 + 34 * x3 + 34 * x4 >= 55",
    "9 * x0 + 8 * x1 + 3 * x5 >= 55",
    "1 * x4 + 5 * x6 >= 56",
    "33 * x0 + 11 * x5 >= 74",
    "33 * x0 + 20 * x1 >= 70",
    "4 * x2 + 5 * x6 >= 68",
    "13 * x3 + 5 * x6 >= 94",
    "33 * x0 + 5 * x6 >= 41",
    "1 * x4 + 11 * x5 >= 74",
    "4 * x2 + 13 * x3 >= 86",
    "33 * x0 + 11 * x5 + 5 * x6 >= 85",
    "33 * x0 + 4 * x2 + 1 * x4 >= 85",
    "33 * x0 + 11 * x5 + 5 * x6 >= 102",
    "33 * x0 + 4 * x2 + 1 * x4 >= 102",
    "9 * x3 + 21 * x4 >= 88",
    "14 * x0 + 25 * x5 >= 99",
    "17 * x1 + 15 * x6 >= 110",
    "14 * x0 + 17 * x1 >= 61",
    "8 * x2 + 21 * x4 >= 45",
    "14 * x0 + 8 * x2 >= 60",
    "9 * x3 + 25 * x5 >= 76",
    "17 * x1 + 21 * x4 >= 110",
    "14 * x0 + 21 * x4 >= 105",
    "8 * x2 + 15 * x6 >= 64",
    "25 * x5 + 15 * x6 >= 46",
    "9 * x3 + 25 * x5 + 15 * x6 >= 102",
    "8 * x2 + 21 * x4 + 25 * x5 >= 102",
    "14 * x0 + 8 * x2 + 25 * x5 >= 102",
    "14 * x0 + 8 * x2 + 15 * x6 >= 102",
    "14 * x0 + 17 * x1 + 25 * x5 >= 102",
    "17 * x1 + 8 * x2 + 15 * x6 >= 102",
    "14 * x0 + 17 * x1 + 9 * x3 >= 102",
    "14 * x0 + 17 * x1 + 21 * x4 >= 102",
    "17 * x1 + 25 * x5 + 15 * x6 >= 102",
    "17 * x1 + 8 * x2 + 9 * x3 >= 102",
    "14 * x0 + 8 * x2 + 21 * x4 >= 102",
    "14 * x0 + 17 * x1 + 15 * x6 >= 102",
    "14 * x0 + 8 * x2 + 9 * x3 >= 102",
    "9 * x3 + 21 * x4 + 25 * x5 >= 102",
    "14 * x0 + 25 * x5 + 15 * x6 >= 102",
    "14 * x0 + 21 * x4 + 25 * x5 >= 102",
    "8 * x2 + 9 * x3 + 25 * x5 >= 102",
    "8 * x2 + 9 * x3 + 21 * x4 >= 102",

    "26 * x2 + 21 * x4 >= 107",
    "24 * x0 + 26 * x2 >= 56",
    "3 * x4 + 2 * x6 >= 77",
    "26 * x2 + 23 * x5 >= 41",
    "10 * x1 + 3 * x4 >= 77",
    "24 * x0 + 15 * x3 >= 47",
    "24 * x0 + 23 * x5 >= 97",
    "10 * x1 + 26 * x2 >= 52"
}

for constraint_str in constraints_json:
    if ">=" in constraint_str:
        lhs, rhs = constraint_str.split(">=")
        model.addConstr(eval(lhs, variables) >= eval(rhs))
    elif "<=" in constraint_str:
        lhs, rhs = constraint_str.split("<=")
        model.addConstr(eval(lhs, variables) <= eval(rhs))
    elif "=" in constraint_str:
        lhs, rhs = constraint_str.split("=")
        model.addConstr(eval(lhs, variables) == eval(rhs))


# Optimize model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

