
from gurobipy import *

# Create a model
m = Model("Employee_Hours")

# Define variables
x1 = m.addVar(lb=0, name="George")
x2 = m.addVar(lb=0, name="John")
x3 = m.addVar(lb=0, name="Laura")
x4 = m.addVar(lb=0, name="Bobby")
x5 = m.addVar(lb=0, name="Mary")
x6 = m.addVar(lb=0, name="Hank")
x7 = m.addVar(lb=0, name="Paul")

# Define objective function
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MAXIMIZE)

# Add constraints
m.addConstr(80*x1 + 70*x2 + 60*x3 + 50*x4 + 40*x5 + 30*x6 + 20*x7 <= 1000)
m.addConstr(x1 + x2 + x3 + x4 + x5 + x6 + x7 >= 10)
m.addConstr(x1 <= 5)
m.addConstr(x2 <= 5)
m.addConstr(x3 <= 5)
m.addConstr(x4 <= 5)
m.addConstr(x5 <= 5)
m.addConstr(x6 <= 5)
m.addConstr(x7 <= 5)

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
