
import gurobi as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
x = model.addVars(7, name="hours_worked", lb=0)

# Set the variable names for easier reference
x[0].setAttr("Name", "George")
x[1].setAttr("Name", "John")
x[2].setAttr("Name", "Laura")
x[3].setAttr("Name", "Bobby")
x[4].setAttr("Name", "Mary")
x[5].setAttr("Name", "Hank")
x[6].setAttr("Name", "Paul")

# Define the objective function
model.setObjective(6.15*x[0] + 4.52*x[1] + 6.66*x[2] + 7.61*x[3] + 1.6*x[4] + 4.75*x[5] + 6.55*x[6], gp.GRB.MAXIMIZE)

# Add constraints
# George's ratings
model.addConstr(9*x[0] <= 747)  # Computer
model.addConstr(33*x[0] <= 734)  # Likelihood to quit
model.addConstr(14*x[0] <= 804)  # Work quality
model.addConstr(24*x[0] <= 752)  # Organization
model.addConstr(8*x[0] <= 685)  # Paperwork

# John's ratings
model.addConstr(8*x[1] <= 747)  # Computer
model.addConstr(20*x[1] <= 734)  # Likelihood to quit
model.addConstr(17*x[1] <= 804)  # Work quality
model.addConstr(10*x[1] <= 752)  # Organization
model.addConstr(13*x[1] <= 685)  # Paperwork

# Laura's ratings
model.addConstr(24*x[2] <= 747)  # Computer
model.addConstr(4*x[2] <= 734)  # Likelihood to quit
model.addConstr(8*x[2] <= 804)  # Work quality
model.addConstr(26*x[2] <= 752)  # Organization
model.addConstr(17*x[2] <= 685)  # Paperwork

# Bobby's ratings
model.addConstr(34*x[3] <= 747)  # Computer
model.addConstr(13*x[3] <= 734)  # Likelihood to quit
model.addConstr(9*x[3] <= 804)  # Work quality
model.addConstr(15*x[3] <= 752)  # Organization
model.addConstr(18*x[3] <= 685)  # Paperwork

# Mary's ratings
model.addConstr(34*x[4] <= 747)  # Computer
model.addConstr(x[4] <= 734)  # Likelihood to quit
model.addConstr(21*x[4] <= 804)  # Work quality
model.addConstr(3*x[4] <= 752)  # Organization
model.addConstr(35*x[4] <= 685)  # Paperwork

# Hank's ratings
model.addConstr(3*x[5] <= 747)  # Computer
model.addConstr(11*x[5] <= 734)  # Likelihood to quit
model.addConstr(25*x[5] <= 804)  # Work quality
model.addConstr(23*x[5] <= 752)  # Organization
model.addConstr(4*x[5] <= 685)  # Paperwork

# Paul's ratings
model.addConstr(20*x[6] <= 747)  # Computer
model.addConstr(5*x[6] <= 734)  # Likelihood to quit
model.addConstr(15*x[6] <= 804)  # Work quality
model.addConstr(2*x[6] <= 752)  # Organization
model.addConstr(24*x[6] <= 685)  # Paperwork

# Other constraints
model.addConstr(24*x[2] + 34*x[3] >= 95)  # Computer Laura, Bobby
model.addConstr(9*x[0] + 8*x[1] >= 41)  # Computer George, John
model.addConstr(8*x[1] + 13*x[4] >= 104)  # Computer John, Mary
model.addConstr(24*x[2] + 20*x[6] >= 88)  # Computer Laura, Paul
model.addConstr(34*x[3] + 17*x[1] >= 42)  # Computer Bobby, John
model.addConstr(24*x[2] + 8*x[1] >= 50)  # Computer Laura, John
model.addConstr(9*x[0] + 8*x[1] >= 37)  # Computer George, John

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    for i in range(7):
        print(f"Hours worked by {['George', 'John', 'Laura', 'Bobby', 'Mary', 'Hank', 'Paul'][i]}: {x[i].varValue}")
else:
    print("No optimal solution found")
