
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")


# Set objective function
m.setObjective(2.99 * magnesium + 9.81 * vitamin_b7 + 2.56 * vitamin_b4 + 7.53 * vitamin_b3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * magnesium + 25 * vitamin_b4 >= 11, "c0")
m.addConstr(25 * vitamin_b4 + 18 * vitamin_b3 >= 22, "c1")
m.addConstr(23 * vitamin_b7 + 18 * vitamin_b3 >= 36, "c2")
m.addConstr(14 * magnesium + 25 * vitamin_b4 >= 50, "c3")
m.addConstr(14 * magnesium + 23 * vitamin_b7 + 25 * vitamin_b4 >= 61, "c4")
m.addConstr(14 * magnesium + 25 * vitamin_b4 + 18 * vitamin_b3 >= 61, "c5")
m.addConstr(14 * magnesium + 23 * vitamin_b7 + 25 * vitamin_b4 >= 45, "c6")
m.addConstr(14 * magnesium + 25 * vitamin_b4 + 18 * vitamin_b3 >= 45, "c7")
m.addConstr(10 * vitamin_b7 + 2 * vitamin_b4 <= 119, "c8")
m.addConstr(22 * magnesium + 2 * vitamin_b4 <= 101, "c9")
m.addConstr(22 * magnesium + 3 * vitamin_b3 <= 120, "c10")
m.addConstr(22 * magnesium + 10 * vitamin_b7 + 2 * vitamin_b4 + 3 * vitamin_b3 <= 120, "c11")
m.addConstr(7 * magnesium + 5 * vitamin_b7 <= 94, "c12")
m.addConstr(5 * vitamin_b7 + 25 * vitamin_b4 <= 108, "c13")
m.addConstr(7 * magnesium + 6 * vitamin_b3 <= 106, "c14")
m.addConstr(5 * vitamin_b7 + 6 * vitamin_b3 <= 74, "c15")
m.addConstr(7 * magnesium + 25 * vitamin_b4 <= 136, "c16")
m.addConstr(25 * vitamin_b4 + 6 * vitamin_b3 <= 40, "c17")
m.addConstr(7 * magnesium + 5 * vitamin_b7 + 25 * vitamin_b4 + 6 * vitamin_b3 <= 40, "c18")
m.addConstr(23 * vitamin_b7 + 18 * vitamin_b3 <= 83, "c19")
m.addConstr(14 * magnesium + 25 * vitamin_b4 <= 172, "c20")
m.addConstr(14 * magnesium + 23 * vitamin_b7 <= 182, "c21")
m.addConstr(14 * magnesium + 18 * vitamin_b3 <= 73, "c22")
m.addConstr(14 * magnesium + 23 * vitamin_b7 + 25 * vitamin_b4 + 18 * vitamin_b3 <= 73, "c23")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

