
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=-gurobi.GRB.INFINITY)  # milligrams of magnesium
    x1 = model.addVar(name='x1', lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B7
    x2 = model.addVar(name='x2', lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B4
    x3 = model.addVar(name='x3', lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B3

    # Define the objective function
    model.setObjective(2.99 * x0 + 9.81 * x1 + 2.56 * x2 + 7.53 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(22 * x0 <= 121)
    model.addConstr(7 * x0 <= 139)
    model.addConstr(14 * x0 <= 263)
    model.addConstr(10 * x1 <= 121)
    model.addConstr(5 * x1 <= 139)
    model.addConstr(23 * x1 <= 263)
    model.addConstr(2 * x2 <= 121)
    model.addConstr(25 * x2 <= 139)
    model.addConstr(25 * x2 <= 263)
    model.addConstr(3 * x3 <= 121)
    model.addConstr(6 * x3 <= 139)
    model.addConstr(18 * x3 <= 263)
    model.addConstr(7 * x0 + 25 * x2 >= 11)
    model.addConstr(25 * x2 + 18 * x3 >= 22)
    model.addConstr(23 * x1 + 18 * x3 >= 36)
    model.addConstr(14 * x0 + 25 * x2 >= 50)
    model.addConstr(14 * x0 + 23 * x1 + 25 * x2 >= 61)
    model.addConstr(14 * x0 + 25 * x2 + 18 * x3 >= 61)
    model.addConstr(14 * x0 + 23 * x1 + 25 * x2 >= 45)
    model.addConstr(14 * x0 + 25 * x2 + 18 * x3 >= 45)
    model.addConstr(10 * x1 + 2 * x2 <= 119)
    model.addConstr(22 * x0 + 2 * x2 <= 101)
    model.addConstr(22 * x0 + 3 * x3 <= 120)
    model.addConstr(22 * x0 + 10 * x1 + 2 * x2 + 3 * x3 <= 120)
    model.addConstr(7 * x0 + 5 * x1 <= 94)
    model.addConstr(5 * x1 + 25 * x2 <= 108)
    model.addConstr(7 * x0 + 6 * x3 <= 106)
    model.addConstr(5 * x1 + 6 * x3 <= 74)
    model.addConstr(7 * x0 + 25 * x2 <= 136)
    model.addConstr(25 * x2 + 6 * x3 <= 40)
    model.addConstr(7 * x0 + 5 * x1 + 25 * x2 + 6 * x3 <= 40)
    model.addConstr(23 * x1 + 18 * x3 <= 83)
    model.addConstr(14 * x0 + 25 * x2 <= 172)
    model.addConstr(14 * x0 + 23 * x1 <= 182)
    model.addConstr(14 * x0 + 18 * x3 <= 73)
    model.addConstr(14 * x0 + 23 * x1 + 25 * x2 + 18 * x3 <= 73)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Milligrams of magnesium: ", x0.varValue)
        print("Milligrams of vitamin B7: ", x1.varValue)
        print("Milligrams of vitamin B4: ", x2.varValue)
        print("Milligrams of vitamin B3: ", x3.varValue)
        print("Objective function value: ", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
